/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service.parsenode;

import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.parser4j.parser.entity.EnumNodeType;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import net.sf.parser4j.parser.entity.parsenode.CharacterParseNode;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.StringParseNode;
import net.sf.parser4j.parser.entity.parsestate.IParseState;
import net.sf.parser4j.parser.entity.parsestate.ParseStack;
import net.sf.parser4j.parser.entity.parsestate.ParseStackElement;
import net.sf.parser4j.parser.service.parsenode.IParseNodeVisitor;
import org.apache.log4j.Logger;

public final class ParsingToStringUtil
implements IParseNodeVisitor {
    private static final Logger _log = Logger.getLogger(ParsingToStringUtil.class);
    private static final ParsingToStringUtil INSTANCE = new ParsingToStringUtil();
    private transient StringBuilder inVisitStringBuilder;
    private transient int numberOfTab;
    private Map<Integer, NonTerminal> nonTerminalByIdentifierMap;
    private final transient Set<Integer> visitedSet = new TreeSet<Integer>();

    public static ParsingToStringUtil getInstance() {
        return INSTANCE;
    }

    private ParsingToStringUtil() {
    }

    public void setNonTerminalByIdentifierMap(Map<Integer, NonTerminal> nonTerminalByIdentifierMap) {
        this.nonTerminalByIdentifierMap = nonTerminalByIdentifierMap;
    }

    public String parseStateToString(IParseState parseState, boolean[] tokenRecognition, boolean addParseTree) {
        StringBuilder builder = new StringBuilder();
        if (parseState.isEmpty()) {
            builder.append("empty parse state\n");
        } else {
            builder.append(this.parseStacksToString(parseState.toArray(), tokenRecognition, addParseTree));
        }
        return builder.toString();
    }

    public String parseStacksToString(ParseStack[] parseStacks, boolean[] tokenRecognition, boolean addParseTree) {
        StringBuilder builder = new StringBuilder();
        ParseStack[] parseStackArray = parseStacks;
        int n = parseStacks.length;
        int n2 = 0;
        while (n2 < n) {
            ParseStack parseStack = parseStackArray[n2];
            builder.append(this.parseStackToString(parseStack, tokenRecognition, addParseTree));
            builder.append('\n');
            ++n2;
        }
        return builder.toString();
    }

    public String parseStackToString(ParseStack parseStack, boolean[] tokenRecognition, boolean addParseTree) {
        int stateNumber;
        StringBuilder builder = new StringBuilder();
        Deque<ParseStackElement> que = parseStack.getParseStateNodeStack();
        builder.append("stack begin\n");
        if (parseStack.isMatchAll()) {
            builder.append("match all\n");
        }
        int index = 0;
        for (ParseStackElement parseStackElement : que) {
            builder.append('#');
            builder.append(index);
            builder.append(" : ");
            stateNumber = parseStackElement.getStateNumber();
            builder.append(stateNumber);
            if (tokenRecognition[stateNumber]) {
                builder.append("(token)");
            }
            builder.append(" , ");
            IParseNode parseNode = parseStackElement.getParseNode();
            this.parseNodeToString(builder, parseNode);
            builder.append('\n');
            if (addParseTree) {
                builder.append(this.parseTreeToString(parseNode));
                builder.append('\n');
            }
            ++index;
        }
        builder.append('#');
        builder.append(index);
        builder.append(" : ");
        stateNumber = parseStack.getStateNumber();
        builder.append(stateNumber);
        if (stateNumber != -1 && tokenRecognition[stateNumber]) {
            builder.append('*');
        }
        builder.append('\n');
        builder.append("stack end\n");
        return builder.toString();
    }

    public String parseNodesToString(IParseNode[] parseNodes, boolean addParseTree) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        IParseNode[] iParseNodeArray = parseNodes;
        int n = parseNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode parseNode = iParseNodeArray[n2];
            builder.append('#');
            builder.append(index++);
            builder.append(": ");
            this.parseNodeToString(builder, parseNode);
            builder.append('\n');
            if (addParseTree) {
                builder.append(this.parseTreeToString(parseNode));
            }
            ++n2;
        }
        return builder.toString();
    }

    public String parseNodeToString(IParseNode parseNode) {
        StringBuilder builder = new StringBuilder();
        this.parseNodeToString(builder, parseNode);
        return builder.toString();
    }

    public String parseTreeToString(IParseNode rootParseNode) {
        this.visitedSet.clear();
        this.inVisitStringBuilder = new StringBuilder();
        this.numberOfTab = 0;
        try {
            rootParseNode.accept(this);
        }
        catch (Exception exception) {
            _log.error((Object)"visiting", (Throwable)exception);
        }
        String toString = this.inVisitStringBuilder.toString();
        this.visitedSet.clear();
        return toString;
    }

    @Override
    public boolean beginVisit(IParseNode parseNode) {
        boolean visitSon;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("begin visit of " + parseNode.getMyIdentifier()));
        }
        this.addTab();
        if (this.visitedSet.add(parseNode.getMyIdentifier())) {
            this.inVisitStringBuilder.append("begin ");
            this.parseNodeToString(this.inVisitStringBuilder, parseNode);
            this.inVisitStringBuilder.append('\n');
            visitSon = true;
            ++this.numberOfTab;
        } else {
            this.inVisitStringBuilder.append("already visited ");
            this.parseNodeToString(this.inVisitStringBuilder, parseNode);
            this.inVisitStringBuilder.append('\n');
            visitSon = false;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("number visited " + this.visitedSet.size()));
        }
        return visitSon;
    }

    @Override
    public boolean visitFirstAlternativeOnly() {
        return false;
    }

    @Override
    public void beginAlternativeVisit(IParseNode node, int alternativeNumber) {
        if (node.getNumberOfAlternative() > 1) {
            this.addTab();
            this.inVisitStringBuilder.append("begin alternative #");
            this.inVisitStringBuilder.append(alternativeNumber);
            this.inVisitStringBuilder.append(' ');
            this.inVisitStringBuilder.append(this.grammarSymbolIdentifierToString(node.getGrammarSymbolIdentifier()));
            this.inVisitStringBuilder.append('\n');
            ++this.numberOfTab;
        }
    }

    @Override
    public void endAlternativeVisit(IParseNode node, int alternativeNumber) {
        if (node.getNumberOfAlternative() > 1) {
            --this.numberOfTab;
            this.addTab();
            this.inVisitStringBuilder.append("end alternative #");
            this.inVisitStringBuilder.append(alternativeNumber);
            this.inVisitStringBuilder.append('\n');
        }
    }

    @Override
    public void endVisit(IParseNode parseNode) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("end visit of " + parseNode.getMyIdentifier()));
        }
        --this.numberOfTab;
        this.addTab();
        this.inVisitStringBuilder.append("end ");
        this.inVisitStringBuilder.append(this.grammarSymbolIdentifierToString(parseNode.getGrammarSymbolIdentifier()));
        this.inVisitStringBuilder.append('\n');
    }

    private void addTab() {
        int count = 0;
        while (count < this.numberOfTab) {
            this.inVisitStringBuilder.append(' ');
            ++count;
        }
    }

    private void parseNodeToString(StringBuilder stringBuilder, IParseNode parseNode) {
        int grammarSymbolIdentifier = parseNode.getGrammarSymbolIdentifier();
        EnumNodeType parseNodeType = parseNode.getParseNodeType();
        stringBuilder.append((Object)parseNodeType);
        stringBuilder.append(' ');
        stringBuilder.append(this.grammarSymbolIdentifierToString(grammarSymbolIdentifier));
        stringBuilder.append('(');
        stringBuilder.append(grammarSymbolIdentifier);
        stringBuilder.append(')');
        if (EnumNodeType.CHARACTER_TERMINAL.equals((Object)parseNodeType)) {
            int terminalIdentifier = ((CharacterParseNode)parseNode).getTerminalValue();
            stringBuilder.append(' ');
            stringBuilder.append(this.terminalIdentifierToString(terminalIdentifier));
        } else if (EnumNodeType.STRING_TERMINAL.equals((Object)parseNodeType)) {
            String value = ((StringParseNode)parseNode).getStringValue();
            stringBuilder.append(' ');
            stringBuilder.append(value);
        }
    }

    public String grammarSymbolIdentifierToString(int grammarSymbolIdentifier) {
        NonTerminal nonTerminal;
        String toString = grammarSymbolIdentifier < 65536 ? this.terminalIdentifierToString(grammarSymbolIdentifier) : ((nonTerminal = this.nonTerminalByIdentifierMap.get(grammarSymbolIdentifier)).isToken() ? String.valueOf(nonTerminal.getName()) + " (token)" : nonTerminal.getName());
        return toString;
    }

    public String terminalIdentifierToString(int terminalIdentifier) {
        String toString = terminalIdentifier < 32 || terminalIdentifier >= 127 ? String.format("\\u%04X", terminalIdentifier) : "'" + (char)terminalIdentifier + "'";
        return toString;
    }
}

