/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service.parsenode;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.parser4j.parser.entity.ParseTreeInfo;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.service.HasAmbiguityParserException;
import net.sf.parser4j.parser.service.ParserException;

public final class ParseTreeToXML {
    private static final ParseTreeToXML INSTANCE = new ParseTreeToXML();

    public static ParseTreeToXML getInstance() {
        return INSTANCE;
    }

    private ParseTreeToXML() {
    }

    public void toXml(String filePrefix, HasAmbiguityParserException exception, Map<Integer, NonTerminal> nonTerminalByIdentifierMap) throws ParserException {
        File prefix = new File(filePrefix);
        File dirFile = prefix.getParentFile();
        File[] fileList = dirFile.listFiles();
        Pattern pattern = Pattern.compile(String.valueOf(prefix.getName()) + "\\d+\\.xml");
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Matcher matcher = pattern.matcher(file.getName());
            if (matcher.matches()) {
                file.delete();
            }
            ++n2;
        }
        List<IParseNode> parseNodeList = exception.getWithAlternativeParseNodeList();
        int index = 0;
        for (IParseNode rootParseNode : parseNodeList) {
            File outputFile = new File(String.valueOf(filePrefix) + index + ".xml");
            this.toXml(outputFile, rootParseNode, nonTerminalByIdentifierMap);
            ++index;
        }
    }

    public void toXml(File outputFile, IParseNode rootParseNode, Map<Integer, NonTerminal> nonTerminalByIdentifierMap) throws ParserException {
        XStream stream = new XStream();
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(outputFile);
                ParseTreeInfo parseTreeInfo = new ParseTreeInfo(rootParseNode, nonTerminalByIdentifierMap);
                stream.toXML((Object)parseTreeInfo, (OutputStream)outputStream);
            }
            catch (FileNotFoundException exception) {
                throw new ParserException(exception);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

