/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service.parsenode;

import net.sf.parser4j.parser.entity.EnumNodeType;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.service.parsenode.AlternativeParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.CharacterParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.ConcatParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.EmptyParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.IParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.StringParseNodeCreator;

public final class ParseNodeFactory {
    private static final ParseNodeFactory INSTANCE = new ParseNodeFactory();
    private final IParseNodeCreator[] parseNodeClassArray;

    public static ParseNodeFactory getInstance() {
        return INSTANCE;
    }

    private ParseNodeFactory() {
        EnumNodeType[] enumNodeTypes = EnumNodeType.values();
        this.parseNodeClassArray = new IParseNodeCreator[enumNodeTypes.length];
        this.parseNodeClassArray[EnumNodeType.ALTERNATIVE.ordinal()] = new AlternativeParseNodeCreator();
        this.parseNodeClassArray[EnumNodeType.CONCAT.ordinal()] = new ConcatParseNodeCreator();
        this.parseNodeClassArray[EnumNodeType.EMPTY.ordinal()] = new EmptyParseNodeCreator();
        this.parseNodeClassArray[EnumNodeType.STRING_TERMINAL.ordinal()] = new StringParseNodeCreator();
        this.parseNodeClassArray[EnumNodeType.CHARACTER_TERMINAL.ordinal()] = new CharacterParseNodeCreator();
    }

    public IParseNode create(int nodeType, IParseNode[] parseNodes) {
        return this.parseNodeClassArray[nodeType].create(parseNodes);
    }
}

