/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service.parsenode;

import net.sf.parser4j.parser.entity.EnumNodeType;
import net.sf.parser4j.parser.entity.parsenode.CharacterParseNode;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.service.parsenode.IParseNodeCreator;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;

public class CharacterParseNodeCreator
implements IParseNodeCreator {
    private static final ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();

    @Override
    public IParseNode create(IParseNode[] parseNodes) {
        if (parseNodes.length != 1) {
            throw new IllegalArgumentException("must have one and only one son\n" + parsingToStringUtil.parseNodesToString(parseNodes, true));
        }
        IParseNode parseNode = parseNodes[0];
        if (!EnumNodeType.CHARACTER_TERMINAL.equals((Object)parseNode.getParseNodeType())) {
            throw new IllegalArgumentException("son must be terminal and is " + (Object)((Object)parseNode.getParseNodeType()));
        }
        CharacterParseNode characterParseNode = new CharacterParseNode((CharacterParseNode)parseNode);
        return characterParseNode;
    }
}

