/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.parser4j.parser.entity.data.ParserData;
import net.sf.parser4j.parser.service.ParserException;
import org.apache.log4j.Logger;

public final class ParserDataIO {
    private static final Logger _log = Logger.getLogger(ParserDataIO.class);
    private static final ParserDataIO INSTANCE = new ParserDataIO();

    private ParserDataIO() {
    }

    public static ParserDataIO getInstance() {
        return INSTANCE;
    }

    public ParserData readFromClassPackage(Class<?> clazz, String resourceName) throws ParserException {
        String path = String.valueOf(clazz.getPackage().getName().replace('.', '/')) + "/" + resourceName;
        return this.readFromClassPath(path);
    }

    public ParserData readFromClassPath(String path) throws ParserException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IllegalArgumentException(String.valueOf(path) + " resource does not exist");
        }
        ParserData parserData = this.readFromInputStream(path, inputStream);
        return parserData;
    }

    public ParserData readFromFile(File parserDataFile) throws ParserException {
        try {
            FileInputStream inputStream = new FileInputStream(parserDataFile);
            ParserData parserData = this.readFromInputStream(parserDataFile.getName(), inputStream);
            return parserData;
        }
        catch (FileNotFoundException exception) {
            throw new ParserException(exception);
        }
    }

    private ParserData readFromInputStream(String path, InputStream inputStream) throws ParserException {
        ParserData parserData;
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream must be defined");
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                try {
                    parserData = (ParserData)objectInputStream.readObject();
                }
                catch (ClassNotFoundException exception) {
                    throw new ParserException("loading resource " + path, exception);
                }
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException exception) {
            try {
                inputStream.close();
            }
            catch (IOException exception2) {
                _log.error((Object)"closing", (Throwable)exception2);
            }
            throw new ParserException("loading resource " + path, exception);
        }
        return parserData;
    }

    public void writeToFile(File parserDataOutputFile, ParserData parserData) throws ParserException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(parserDataOutputFile);
            ObjectOutputStream objectOutputStream = null;
            try {
                try {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(parserData);
                }
                catch (IOException exception) {
                    throw new ParserException("saving resource " + parserDataOutputFile, exception);
                }
            }
            finally {
                try {
                    objectOutputStream.close();
                }
                catch (IOException exception2) {
                    _log.error((Object)"closing", (Throwable)exception2);
                }
            }
        }
        catch (FileNotFoundException exception) {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException exception2) {
                    _log.error((Object)"closing", (Throwable)exception2);
                }
            }
            throw new ParserException("saving resource " + parserDataOutputFile, exception);
        }
    }
}

