/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service;

import java.util.Map;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import net.sf.parser4j.parser.entity.parsestate.IParseState;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import org.apache.log4j.Logger;

public final class ParserStackLogger {
    private static final Logger _logStack = Logger.getLogger(ParserStackLogger.class);
    private static final ParserStackLogger INSTANCE = new ParserStackLogger();
    private static final ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();
    private boolean[] tokenRecognition;
    private boolean enabled = true;

    private ParserStackLogger() {
    }

    public static ParserStackLogger getInstance() {
        return INSTANCE;
    }

    public boolean isDebugEnabled() {
        return this.enabled && _logStack.isDebugEnabled();
    }

    public void setNonTerminalByIdentifierMap(Map<Integer, NonTerminal> nonTerminalByIdentifierMap) {
        parsingToStringUtil.setNonTerminalByIdentifierMap(nonTerminalByIdentifierMap);
    }

    public void setTokenRecognition(boolean[] tokenRecognition) {
        this.tokenRecognition = tokenRecognition;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void logParseState(String title, IParseState parseState) {
        StringBuilder builder = new StringBuilder();
        builder.append(title);
        builder.append('\n');
        if (parseState == null) {
            builder.append("null\n");
        } else {
            builder.append(parsingToStringUtil.parseStateToString(parseState, this.tokenRecognition, true));
        }
        _logStack.debug((Object)builder.toString());
    }
}

