/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.ParserFileReader;
import org.apache.log4j.Logger;

public class ParserInput {
    private static final Logger _log = Logger.getLogger(ParserInput.class);
    private final transient Deque<ParserFileReader> parserFileReaderStack = new LinkedList<ParserFileReader>();
    private transient boolean openned;

    public ParserInput(ParserFileReader parserFileReader) throws ParserException {
        this.parserFileReaderStack.addFirst(parserFileReader);
        this.openned = true;
    }

    public int read() throws IOException {
        int readed;
        if (!this.openned) {
            throw new IOException("closed");
        }
        try {
            readed = this.parserFileReaderStack.peekFirst().read();
            while (readed == -1 && this.parserFileReaderStack.size() > 1) {
                this.parserFileReaderStack.pollFirst();
                readed = this.parserFileReaderStack.peekFirst().read();
            }
        }
        catch (IOException exception) {
            this.close();
            this.openned = false;
            throw exception;
        }
        return readed;
    }

    public void close() {
        if (this.openned) {
            for (ParserFileReader parserFileReader : this.parserFileReaderStack) {
                try {
                    parserFileReader.close();
                }
                catch (IOException exception) {
                    _log.error((Object)("closing reader of " + parserFileReader.getFileName()), (Throwable)exception);
                }
            }
            this.openned = false;
        }
    }

    public String getFileName() {
        return this.parserFileReaderStack.peekFirst().getFileName();
    }

    public int getColumnNumber() {
        return this.parserFileReaderStack.peekFirst().getColumnNumber();
    }

    public int getLineNumber() {
        return this.parserFileReaderStack.peekFirst().getLineNumber();
    }

    public void mark() {
        this.parserFileReaderStack.peekFirst().mark();
    }

    public void reset() {
        this.parserFileReaderStack.peekFirst().reset();
    }

    public void include(ParserFileReader parserFileReader) {
        this.parserFileReaderStack.addFirst(parserFileReader);
    }
}

