/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ParserFileReader {
    private static final Logger _log = Logger.getLogger(ParserFileReader.class);
    private final transient BufferedReader bufferedReader;
    private transient int lineNumber;
    private transient int columnNumber;
    private final transient String fileName;
    private final transient Deque<Integer> unreadQue = new LinkedList<Integer>();
    private final transient Deque<Integer> markQue = new LinkedList<Integer>();
    private transient boolean markFlag = false;
    private int markLineNumber;
    private int markColumnNumber;

    public ParserFileReader(Reader reader, String fileName) {
        this.bufferedReader = new BufferedReader(reader);
        this.fileName = fileName;
        this.lineNumber = 1;
        this.columnNumber = 1;
    }

    public int read() throws IOException {
        int readed = this.unreadQue.isEmpty() ? this.bufferedReader.read() : this.unreadQue.pollFirst().intValue();
        if (readed == 10) {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        if (this.markFlag && readed != -1) {
            this.markQue.addLast(readed);
        }
        if (_log.isDebugEnabled()) {
            if (readed == -1) {
                _log.debug((Object)"readed eof");
            } else {
                _log.debug((Object)("readed " + (char)readed));
            }
        }
        return readed;
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void mark() {
        this.markQue.clear();
        this.markFlag = true;
        this.markColumnNumber = this.getColumnNumber();
        this.markLineNumber = this.getLineNumber();
    }

    public void reset() {
        this.markFlag = false;
        Iterator<Integer> iterator = this.markQue.descendingIterator();
        while (iterator.hasNext()) {
            this.unreadQue.addFirst(iterator.next());
        }
        this.markQue.clear();
        this.columnNumber = this.markColumnNumber;
        this.lineNumber = this.markLineNumber;
    }
}

