/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service;

import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.parser4j.parser.entity.ParseResult;
import net.sf.parser4j.parser.entity.ParseSession;
import net.sf.parser4j.parser.entity.data.GotoByNonTerminalEntry;
import net.sf.parser4j.parser.entity.data.GotoByTerminalEntry;
import net.sf.parser4j.parser.entity.data.MatchEntry;
import net.sf.parser4j.parser.entity.data.MatchEntrySet;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import net.sf.parser4j.parser.entity.data.ParserData;
import net.sf.parser4j.parser.entity.data.TerminalCharRange;
import net.sf.parser4j.parser.entity.data.ToStateAndWhiteSpaceFlag;
import net.sf.parser4j.parser.entity.parsenode.CharacterParseNode;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeInErrorStatus;
import net.sf.parser4j.parser.entity.parsestate.AbstractParseState;
import net.sf.parser4j.parser.entity.parsestate.LexParseState;
import net.sf.parser4j.parser.entity.parsestate.ParseStack;
import net.sf.parser4j.parser.entity.parsestate.ParseStackElement;
import net.sf.parser4j.parser.entity.parsestate.SyntaxParseState;
import net.sf.parser4j.parser.service.HasAmbiguityParserException;
import net.sf.parser4j.parser.service.IParserListener;
import net.sf.parser4j.parser.service.MatchMgrInvoker;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.ParserFileReader;
import net.sf.parser4j.parser.service.ParserInput;
import net.sf.parser4j.parser.service.ParserStackLogger;
import net.sf.parser4j.parser.service.parsenode.ParseNodeFactory;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import org.apache.log4j.Logger;

public class Parser {
    private static final Logger _log = Logger.getLogger(Parser.class);
    private static final ParserStackLogger parserStackLogger = ParserStackLogger.getInstance();
    private static final ParseNodeFactory parseNodeFactory = ParseNodeFactory.getInstance();
    public static final int ENDING_STATE_NUMBER = -1;
    public static final ToStateAndWhiteSpaceFlag ENDING_STATE = new ToStateAndWhiteSpaceFlag(-1, false);
    private final MatchMgrInvoker matchClassInvoker;
    private final Map<Integer, NonTerminal> nonTerminalByIdentifierMap;
    private final GotoByTerminalEntry[] gotoByTerminalTable;
    private final GotoByTerminalEntry[] tokenGotoByTerminalTable;
    private final GotoByNonTerminalEntry[] gotoByNonTerminalTable;
    private final GotoByNonTerminalEntry[] tokenGotoByNonTerminalTable;
    private final MatchEntrySet[] matchTable;
    private final MatchEntrySet[] tokenMatchTable;
    private final boolean[] tokenRecognition;
    private final int rootNonTerminalIdentifier;
    private final IParserListener listener;
    private transient ParseResult parseResult;
    private transient boolean alternativeForAmbiguity;
    private transient ParseStack[] parseStacks;
    private transient ParseStack[] tokenParseStacks;
    private final transient ParseSession parseSession;
    private transient int currentColumnNumber;
    private transient int currentLineNumber;
    private transient SyntaxParseState syntaxParseState;
    private transient LexParseState lexParseState;
    private transient ParserInput parserInput;
    private transient List<IParseNode> matchedTokenList;
    private transient boolean skipReduceAfterError;
    private transient ParserException reduceException;
    private transient int reduceErrorLineNumber;
    private transient int reduceErrorColumnNumber;
    private transient int maxNumberOfAlternative;

    public Parser(ParserData parserData, IParserListener listener) throws ParserException {
        this.listener = listener;
        String[] matchClassNameTable = parserData.getMatchClassNameTable();
        this.matchClassInvoker = new MatchMgrInvoker(matchClassNameTable);
        this.gotoByTerminalTable = parserData.getGotoByTerminalTable();
        this.tokenGotoByTerminalTable = parserData.getTokenGotoByTerminalTable();
        this.gotoByNonTerminalTable = parserData.getGotoByNonTerminalTable();
        this.tokenGotoByNonTerminalTable = parserData.getTokenGotoByNonTerminalTable();
        this.matchTable = parserData.getMatchTable();
        this.tokenMatchTable = parserData.getTokenMatchTable();
        this.rootNonTerminalIdentifier = parserData.getRootNonTerminalIdentifier();
        this.tokenRecognition = parserData.getTokenRecognition();
        parserStackLogger.setTokenRecognition(this.tokenRecognition);
        this.parseSession = new ParseSession();
        this.nonTerminalByIdentifierMap = parserData.getNonTerminalByIdentifierMap();
        parserStackLogger.setNonTerminalByIdentifierMap(this.nonTerminalByIdentifierMap);
        this.maxNumberOfAlternative = 10;
    }

    public void setMaxNumberOfAlternative(int maxNumberOfAlternative) {
        this.maxNumberOfAlternative = maxNumberOfAlternative;
    }

    public ParseSession getParseSession() {
        return this.parseSession;
    }

    public ParseResult parse(ParserFileReader parserFileReader, boolean syntaxAcceptAmbiguity, boolean lexAcceptAmbiguity) throws ParserException, HasAmbiguityParserException {
        int terminalValue;
        this.matchClassInvoker.initialize();
        this.skipReduceAfterError = false;
        this.parserInput = new ParserInput(parserFileReader);
        this.parseSession.setParserInput(this.parserInput);
        this.currentColumnNumber = this.parserInput.getColumnNumber();
        this.currentLineNumber = this.parserInput.getLineNumber();
        this.syntaxParseState = new SyntaxParseState(syntaxAcceptAmbiguity, this.maxNumberOfAlternative, this.tokenRecognition);
        ParseStack initialParseStack = new ParseStack();
        this.syntaxParseState.add(initialParseStack);
        this.checkForMatch(true, initialParseStack);
        boolean syntaxMode = true;
        this.parseSession.setSyntaxMode(syntaxMode);
        boolean hasTokenRecognition = this.syntaxParseState.hasTokenRecognition();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("hasTokenRecognition " + hasTokenRecognition));
        }
        do {
            if (syntaxMode && hasTokenRecognition) {
                ParseStack[] parseStacks;
                this.parserInput.mark();
                this.matchedTokenList = null;
                syntaxMode = false;
                this.parseSession.setSyntaxMode(syntaxMode);
                List<ParseStack> list = this.syntaxParseState.poolTokenRecognitionParseStackList();
                this.lexParseState = this.newLexParseState(lexAcceptAmbiguity, list);
                ParseStack[] parseStackArray = parseStacks = this.lexParseState.toArray();
                int n = parseStacks.length;
                int n2 = 0;
                while (n2 < n) {
                    ParseStack lexParseStack = parseStackArray[n2];
                    this.checkForMatch(syntaxMode, lexParseStack);
                    ++n2;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("have token match " + (this.matchedTokenList != null)));
                }
            }
            if (syntaxMode) {
                this.lexParseState = null;
                do {
                    if (parserStackLogger.isDebugEnabled()) {
                        parserStackLogger.logParseState("syntax: before parse", this.syntaxParseState);
                    }
                    terminalValue = this.parse(true);
                    hasTokenRecognition = this.syntaxParseState.hasTokenRecognition();
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("hasTokenRecognition " + hasTokenRecognition));
                } while (terminalValue != -1 && !this.syntaxParseState.isEmpty() && !hasTokenRecognition);
                continue;
            }
            do {
                if (!parserStackLogger.isDebugEnabled()) continue;
                parserStackLogger.logParseState("lex: before parse", this.lexParseState);
            } while ((terminalValue = this.parse(false)) != -1 && !this.lexParseState.isEmpty());
            syntaxMode = true;
            this.parseSession.setSyntaxMode(syntaxMode);
            if (this.matchedTokenList == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"no token match");
                }
                hasTokenRecognition = false;
            } else {
                if (parserStackLogger.isDebugEnabled()) {
                    parserStackLogger.logParseState("syntax: before shift by token", this.syntaxParseState);
                }
                this.shiftByToken();
                hasTokenRecognition = this.syntaxParseState.hasTokenRecognition();
            }
            this.matchedTokenList = null;
            this.parserInput.reset();
            terminalValue = 0;
        } while (terminalValue != -1 && !this.syntaxParseState.isEmpty());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("parse end: end of input=" + (terminalValue == -1) + ", syntax parse state empty=" + this.syntaxParseState.isEmpty()));
        }
        if (parserStackLogger.isDebugEnabled()) {
            parserStackLogger.logParseState("syntax: end of parsing", this.syntaxParseState);
            parserStackLogger.logParseState("lex: end of parsing", this.lexParseState);
        }
        IParseNode resultParseNode = this.computeResult();
        this.alternativeForAmbiguity = this.syntaxParseState.hasAlternativeForAmbiguity();
        if (resultParseNode == null) {
            this.parseResult = new ParseResult(true);
            this.parseResult.setLastTerminalValueReaded(terminalValue);
            this.parseResult.setResultParseNode(resultParseNode);
            this.parseResult.setParseError(true);
            this.parseResult.setReduceError(false);
            this.computeErrorInfo();
        } else {
            boolean reduceError = this.skipReduceAfterError || resultParseNode.isInError();
            this.parseResult = new ParseResult(reduceError);
            this.parseResult.setLastTerminalValueReaded(terminalValue);
            this.parseResult.setResultParseNode(resultParseNode);
            this.parseResult.setReduceError(reduceError);
            this.parseResult.setParseError(false);
            if (this.skipReduceAfterError) {
                _log.error((Object)("reduce error at " + this.reduceErrorLineNumber + "," + this.reduceErrorColumnNumber), (Throwable)this.reduceException);
                this.parseResult.setReduceErrorInfo(this.reduceException, this.reduceErrorLineNumber, this.reduceErrorColumnNumber, this.parserInput.getFileName());
            } else if (resultParseNode.isInError()) {
                IParseNodeInErrorStatus errorStatus = resultParseNode.getErrorStatus();
                _log.error((Object)("reduce error at " + errorStatus.getBeginLineNumber() + "," + errorStatus.getBeginColumnNumber() + " thru " + errorStatus.getEndLineNumber() + "," + errorStatus.getEndColumnNumber() + "\n" + errorStatus.toString()));
                this.parseResult.setReduceErrorInfo(errorStatus, this.parserInput.getFileName());
            }
        }
        this.parserInput.close();
        return this.parseResult;
    }

    private LexParseState newLexParseState(boolean lexAcceptAmbiguity, List<ParseStack> list) throws ParserException, HasAmbiguityParserException {
        return new LexParseState(lexAcceptAmbiguity, this.maxNumberOfAlternative, this.tokenRecognition, list);
    }

    private String mode(boolean syntaxMode) {
        return syntaxMode ? "syntax" : "lex";
    }

    public boolean hasAlternativeForAmbiguity() {
        return this.alternativeForAmbiguity;
    }

    private IParseNode computeResult() {
        IParseNode resultParseNode = null;
        for (ParseStack parseStack : this.syntaxParseState) {
            if (!parseStack.isMatchAll()) continue;
            if (resultParseNode == null) {
                resultParseNode = parseStack.getMatchAllParseNode();
                continue;
            }
            throw new IllegalStateException("can not have more than one stack matching grammar");
        }
        return resultParseNode;
    }

    private void computeErrorInfo() {
        int stateNumber;
        Object parseStack;
        this.parseResult.setParseStacks(this.parseStacks, this.tokenParseStacks, this.tokenRecognition);
        TreeSet<Integer> endingState = new TreeSet<Integer>();
        Object object = this.parseStacks;
        int n = this.parseStacks.length;
        int n2 = 0;
        while (n2 < n) {
            parseStack = object[n2];
            stateNumber = ((ParseStack)parseStack).getStateNumber();
            if (stateNumber != -1) {
                endingState.add(stateNumber);
            }
            ++n2;
        }
        if (this.lexParseState != null) {
            object = this.tokenParseStacks;
            n = this.tokenParseStacks.length;
            n2 = 0;
            while (n2 < n) {
                parseStack = object[n2];
                stateNumber = ((ParseStack)parseStack).getStateNumber();
                if (stateNumber != -1) {
                    endingState.add(stateNumber);
                }
                ++n2;
            }
        }
        Set<TerminalCharRange> expectedTerminal = this.parseResult.getExpectedTerminal();
        Set<String> expectedNonTerminal = this.parseResult.getExpectedNonTerminal();
        object = endingState.iterator();
        while (object.hasNext()) {
            int stateNumber2 = (Integer)object.next();
            expectedTerminal.addAll(this.gotoByTerminalTable[stateNumber2].expected());
            expectedTerminal.addAll(this.tokenGotoByTerminalTable[stateNumber2].expected());
            Set<Integer> set = this.gotoByNonTerminalTable[stateNumber2].expected();
            for (int nonTerminalIdentifier : set) {
                expectedNonTerminal.add(this.grammarSymbolToString(nonTerminalIdentifier));
            }
            set = this.tokenGotoByNonTerminalTable[stateNumber2].expected();
            for (int nonTerminalIdentifier : set) {
                expectedNonTerminal.add(this.grammarSymbolToString(nonTerminalIdentifier));
            }
        }
        this.parseResult.setInTextPosition(this.parserInput.getLineNumber(), this.parserInput.getColumnNumber() - 1, this.parserInput.getFileName());
    }

    private boolean parseStackEndWith(ParseStack parseStack, int[] expectedStateNumberList) {
        int index = expectedStateNumberList.length - 1;
        boolean found = true;
        if (parseStack.getStateNumber() != expectedStateNumberList[index--]) {
            found = false;
        }
        if (found) {
            Deque<ParseStackElement> que = parseStack.getParseStateNodeStack();
            Iterator<ParseStackElement> iterator = que.descendingIterator();
            while (index >= 0 && found) {
                int stateNumber;
                found = iterator.hasNext() ? (stateNumber = iterator.next().getStateNumber()) == expectedStateNumberList[index--] : false;
            }
        }
        return found;
    }

    private int parse(boolean syntaxMode) throws ParserException, HasAmbiguityParserException {
        this.currentColumnNumber = this.parserInput.getColumnNumber();
        this.currentLineNumber = this.parserInput.getLineNumber();
        int terminalValue = this.readTerminalValue();
        if (terminalValue != -1) {
            this.parse(syntaxMode, terminalValue);
        }
        return terminalValue;
    }

    private void parse(boolean syntaxMode, int terminalValue) throws ParserException, HasAmbiguityParserException {
        CharacterParseNode parseNode = new CharacterParseNode(terminalValue, this.currentLineNumber, this.currentColumnNumber);
        AbstractParseState parseState = syntaxMode ? this.syntaxParseState : this.lexParseState;
        ParseStack[] localParseStacks = parseState.toArray();
        if (syntaxMode) {
            this.parseStacks = localParseStacks;
        } else {
            this.tokenParseStacks = localParseStacks;
        }
        parseState.clear();
        LinkedList<ParseStack> checkForMatchList = new LinkedList<ParseStack>();
        ParseStack[] parseStackArray = localParseStacks;
        int n = localParseStacks.length;
        int n2 = 0;
        while (n2 < n) {
            ParseStack currentParseStack = parseStackArray[n2];
            this.checkShiftByGrammarSymbol(syntaxMode, terminalValue, parseNode, checkForMatchList, currentParseStack);
            ++n2;
        }
        if (parserStackLogger.isDebugEnabled()) {
            parserStackLogger.logParseState(String.valueOf(this.mode(syntaxMode)) + ": after shift by terminal", syntaxMode ? this.syntaxParseState : this.lexParseState);
        }
        for (ParseStack currentParseStack : checkForMatchList) {
            this.checkForMatch(syntaxMode, currentParseStack);
        }
    }

    private void shiftByToken() throws ParserException, HasAmbiguityParserException {
        ParseStack[] parseStacks = this.syntaxParseState.toArray();
        LinkedList<ParseStack> checkForMatchList = new LinkedList<ParseStack>();
        this.syntaxParseState.clear();
        for (IParseNode parseNode : this.matchedTokenList) {
            ParseStack[] parseStackArray = parseStacks;
            int n = parseStacks.length;
            int n2 = 0;
            while (n2 < n) {
                ParseStack currentParseStack = parseStackArray[n2];
                int nonTerminalIdentifier = parseNode.getGrammarSymbolIdentifier();
                this.checkShiftByGrammarSymbol(true, nonTerminalIdentifier, parseNode, checkForMatchList, currentParseStack);
                ++n2;
            }
        }
        if (parserStackLogger.isDebugEnabled()) {
            parserStackLogger.logParseState("syntax: after shift by token", this.syntaxParseState);
        }
        for (ParseStack currentParseStack : checkForMatchList) {
            this.checkForMatch(true, currentParseStack);
        }
    }

    private void checkShiftByGrammarSymbol(boolean syntaxMode, int grammarSymbolIdentifier, IParseNode parseNode, List<ParseStack> checkForMatchList, ParseStack parseStack) throws ParserException, HasAmbiguityParserException {
        int stateNumber = parseStack.getStateNumber();
        ToStateAndWhiteSpaceFlag toStateAndWhiteSpaceFlag = this.toState(syntaxMode, stateNumber, grammarSymbolIdentifier);
        if (toStateAndWhiteSpaceFlag == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(this.mode(syntaxMode)) + ": no shift from " + stateNumber + " by " + this.grammarSymbolToString(grammarSymbolIdentifier) + " (" + grammarSymbolIdentifier + ")"));
            }
        } else {
            this.shift(syntaxMode, toStateAndWhiteSpaceFlag, parseStack, parseNode, grammarSymbolIdentifier);
            (syntaxMode ? this.syntaxParseState : this.lexParseState).add(parseStack);
            checkForMatchList.add(parseStack);
        }
    }

    private int readTerminalValue() throws ParserException {
        int terminalValue;
        try {
            terminalValue = this.parserInput.read();
        }
        catch (IOException exception) {
            throw new ParserException(exception);
        }
        if (terminalValue == 10 && this.listener != null) {
            this.listener.newLine(this.parserInput.getLineNumber());
        }
        if (_log.isDebugEnabled()) {
            String toString = ParsingToStringUtil.getInstance().terminalIdentifierToString(terminalValue);
            _log.debug((Object)("read " + toString + " (" + this.parserInput.getLineNumber() + "," + this.parserInput.getColumnNumber() + ")"));
        }
        return terminalValue;
    }

    private void shift(boolean syntaxMode, ToStateAndWhiteSpaceFlag toStateAndWhiteSpaceFlag, ParseStack parseStack, IParseNode parseNode, int grammarSymbolIdentifier) throws ParserException, HasAmbiguityParserException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(this.mode(syntaxMode)) + ": shift from " + parseStack.getStateNumber() + " to " + toStateAndWhiteSpaceFlag + " by " + this.grammarSymbolToString(grammarSymbolIdentifier) + " (" + grammarSymbolIdentifier + "), white space=" + toStateAndWhiteSpaceFlag.isWhiteSpace()));
        }
        parseNode.setWhiteSpace(toStateAndWhiteSpaceFlag.isWhiteSpace());
        parseStack.shift(parseNode, toStateAndWhiteSpaceFlag.getToState());
    }

    private void checkForMatch(boolean syntaxMode, ParseStack parseStack) throws ParserException, HasAmbiguityParserException {
        int stateNumber = parseStack.getStateNumber();
        MatchEntrySet matchEntrySet = syntaxMode ? this.matchTable[stateNumber] : this.tokenMatchTable[stateNumber];
        if (matchEntrySet.match()) {
            this.matchManagement(syntaxMode, parseStack, matchEntrySet);
        }
    }

    private void matchManagement(boolean syntaxMode, ParseStack parseStack, MatchEntrySet matchEntrySet) throws ParserException, HasAmbiguityParserException {
        Iterator<MatchEntry> entrySetIterator = matchEntrySet.matchEntrySetIterator();
        LinkedList<IParseNode> currentMatchedTokenList = new LinkedList<IParseNode>();
        while (entrySetIterator.hasNext()) {
            MatchEntry matchEntry = entrySetIterator.next();
            int matchedNonterminalIdentifier = matchEntry.getMatchedNonTerminalIdentifier();
            int matchedLength = matchEntry.getMatchedLength();
            IParseNode[] parseNodes = parseStack.getMatchedParseNode(matchedLength);
            int[] notWhiteIndexes = parseStack.getNotWhiteIndexes();
            IParseNodeInErrorStatus parseNodeInErrorStatus = parseStack.getParseNodeInErrorStatus();
            if (!this.matchClassInvoker.confirmReduction(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, this.parseSession)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(this.mode(syntaxMode)) + ": state " + parseStack.getStateNumber() + " match " + this.grammarSymbolToString(matchedNonterminalIdentifier) + " (" + matchedNonterminalIdentifier + ")"));
            }
            int nodeType = matchEntry.getNodeType();
            IParseNode reduceParseNode = this.reduce(syntaxMode, parseStack, matchedNonterminalIdentifier, matchedLength, nodeType, parseNodes, notWhiteIndexes, parseNodeInErrorStatus);
            if (syntaxMode) continue;
            this.checkForTokenMatch(reduceParseNode, currentMatchedTokenList);
        }
        if (!currentMatchedTokenList.isEmpty()) {
            this.parserInput.mark();
            this.matchedTokenList = currentMatchedTokenList;
        }
    }

    private void checkForTokenMatch(IParseNode reduceParseNode, List<IParseNode> currentMatchedTokenList) {
        int nonTerminalIdentifier = reduceParseNode.getGrammarSymbolIdentifier();
        NonTerminal nonTerminal = this.nonTerminalByIdentifierMap.get(nonTerminalIdentifier);
        if (nonTerminal.isToken()) {
            currentMatchedTokenList.add(reduceParseNode);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("token match " + this.grammarSymbolToString(nonTerminalIdentifier)));
            }
        }
    }

    private IParseNode reduce(boolean syntaxMode, ParseStack parseStack, int matchedNonterminalIdentifier, int matchedLength, int nodeType, IParseNode[] parseNodes, int[] notWhiteIndexes, IParseNodeInErrorStatus parseNodeInErrorStatus) throws ParserException, HasAmbiguityParserException {
        IParseNode result;
        AbstractParseState parseState;
        IParseNode reduceParseNode = parseNodeFactory.create(nodeType, parseNodes);
        if (parseNodeInErrorStatus != null) {
            reduceParseNode.setErrorStatus(parseNodeInErrorStatus);
        }
        reduceParseNode.setGrammarSymbolIdentifier(matchedNonterminalIdentifier);
        ParseStack parseStackCopy = parseStack.copy();
        parseStackCopy.reduce(matchedLength);
        AbstractParseState abstractParseState = parseState = syntaxMode ? this.syntaxParseState : this.lexParseState;
        if (matchedNonterminalIdentifier == this.rootNonTerminalIdentifier) {
            if (!syntaxMode) {
                throw new ParserException("start must not be a token");
            }
            parseStackCopy.setMatchAll(reduceParseNode);
            this.shift(syntaxMode, ENDING_STATE, parseStackCopy, reduceParseNode, matchedNonterminalIdentifier);
            parseState.add(parseStackCopy);
            this.reduceAction(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, reduceParseNode, parseNodeInErrorStatus);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"match all the grammar");
            }
            result = null;
        } else {
            int stateNumber = parseStackCopy.getStateNumber();
            ToStateAndWhiteSpaceFlag toStateAndWhiteSpaceFlag = this.toState(syntaxMode, stateNumber, matchedNonterminalIdentifier);
            if (toStateAndWhiteSpaceFlag == null) {
                if (syntaxMode) {
                    Object result2 = null;
                    throw new ParserException(String.valueOf(this.mode(syntaxMode)) + ": must shift from " + stateNumber + " by " + this.grammarSymbolToString(matchedNonterminalIdentifier));
                }
                this.reduceAction(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, reduceParseNode, parseNodeInErrorStatus);
                result = reduceParseNode;
            } else {
                this.shift(syntaxMode, toStateAndWhiteSpaceFlag, parseStackCopy, reduceParseNode, matchedNonterminalIdentifier);
                boolean added = parseState.add(parseStackCopy);
                if (added) {
                    this.reduceAction(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, reduceParseNode, parseNodeInErrorStatus);
                    this.checkForMatch(syntaxMode, parseStackCopy);
                    result = reduceParseNode;
                } else {
                    result = null;
                }
            }
        }
        return result;
    }

    private void reduceAction(int matchedNonterminalIdentifier, IParseNode[] parseNodes, int[] notWhiteIndexes, IParseNode fatherParseNode, IParseNodeInErrorStatus parseNodeInErrorStatus) throws ParserException {
        int beginLineNumber;
        int endLineNumber;
        int beginColumnNumber;
        int endColumnNumber;
        if (parseNodes.length == 0) {
            beginColumnNumber = endColumnNumber = this.currentColumnNumber;
            beginLineNumber = endLineNumber = this.currentLineNumber;
        } else {
            beginLineNumber = parseNodes[0].getBeginLineNumber();
            beginColumnNumber = parseNodes[0].getBeginColumnNumber();
            endLineNumber = parseNodes[parseNodes.length - 1].getEndLineNumber();
            endColumnNumber = parseNodes[parseNodes.length - 1].getEndColumnNumber();
        }
        fatherParseNode.setLineAndColumnNumber(beginLineNumber, beginColumnNumber, endLineNumber, endColumnNumber);
        if (parseNodeInErrorStatus == null) {
            this.matchClassInvoker.reduceAction(matchedNonterminalIdentifier, fatherParseNode, parseNodes, notWhiteIndexes, this.parseSession);
        }
        if (!this.skipReduceAfterError && this.matchClassInvoker.isSkipReduceAfterError()) {
            this.skipReduceAfterError = true;
            this.reduceErrorLineNumber = this.parserInput.getLineNumber();
            this.reduceErrorColumnNumber = this.parserInput.getColumnNumber();
            this.reduceException = this.matchClassInvoker.getReduceException();
        }
    }

    private ToStateAndWhiteSpaceFlag toState(boolean syntaxMode, int stateNumber, int grammarSymbolIdentifier) {
        ToStateAndWhiteSpaceFlag toStateAndWhiteSpaceFlag;
        if (stateNumber == -1) {
            toStateAndWhiteSpaceFlag = null;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(this.mode(syntaxMode)) + ": cancel match all grammar by grammar symbol " + this.grammarSymbolToString(grammarSymbolIdentifier)));
            }
        } else if (syntaxMode) {
            if (grammarSymbolIdentifier < 65536) {
                GotoByTerminalEntry gotoByTerminalEntry = this.gotoByTerminalTable[stateNumber];
                int toState = gotoByTerminalEntry.toState(grammarSymbolIdentifier);
                toStateAndWhiteSpaceFlag = toState == -1 ? null : new ToStateAndWhiteSpaceFlag(toState, false);
            } else {
                GotoByNonTerminalEntry gotoByNonTerminalEntry = this.gotoByNonTerminalTable[stateNumber];
                toStateAndWhiteSpaceFlag = gotoByNonTerminalEntry.toStateAndWhiteSpaceFlag(grammarSymbolIdentifier);
            }
        } else if (grammarSymbolIdentifier < 65536) {
            int toState = this.tokenGotoByTerminalTable[stateNumber].toState(grammarSymbolIdentifier);
            toStateAndWhiteSpaceFlag = toState == -1 ? null : new ToStateAndWhiteSpaceFlag(toState, false);
        } else {
            GotoByNonTerminalEntry gotoByNonTerminalEntry = this.tokenGotoByNonTerminalTable[stateNumber];
            toStateAndWhiteSpaceFlag = gotoByNonTerminalEntry.toStateAndWhiteSpaceFlag(grammarSymbolIdentifier);
        }
        return toStateAndWhiteSpaceFlag;
    }

    private String grammarSymbolToString(int grammarSymbolIdentifier) {
        return ParsingToStringUtil.getInstance().grammarSymbolIdentifierToString(grammarSymbolIdentifier);
    }
}

