/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.service;

import net.sf.parser4j.parser.entity.ParseSession;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.data.IParseNodeData;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.match.IMatchMgr;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import org.apache.log4j.Logger;

public class MatchMgrInvoker {
    private static final Logger _log = Logger.getLogger(MatchMgrInvoker.class);
    private final transient ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();
    private final IMatchMgr[] matchMgrs;
    private transient boolean skipReduceAfterError;
    private transient ParserException reduceException;

    public MatchMgrInvoker(String[] matchClassNameTable) throws ParserException {
        int length = matchClassNameTable.length;
        this.matchMgrs = new IMatchMgr[length];
        try {
            int nonTerminalIndex = 0;
            while (nonTerminalIndex < length) {
                IMatchMgr matchMgr;
                String className = matchClassNameTable[nonTerminalIndex];
                if (className == null) {
                    matchMgr = null;
                } else {
                    Class<?> matchMgrClass = Class.forName(className);
                    matchMgr = (IMatchMgr)matchMgrClass.newInstance();
                }
                this.matchMgrs[nonTerminalIndex] = matchMgr;
                ++nonTerminalIndex;
            }
        }
        catch (ClassNotFoundException exception) {
            throw new ParserException("missing match manager class", exception);
        }
        catch (InstantiationException exception) {
            throw new ParserException("failed instantiate match manager class", exception);
        }
        catch (IllegalAccessException exception) {
            throw new ParserException("failed instantiate match manager class", exception);
        }
    }

    public void initialize() {
        this.skipReduceAfterError = false;
    }

    public boolean isSkipReduceAfterError() {
        return this.skipReduceAfterError;
    }

    public ParserException getReduceException() {
        return this.reduceException;
    }

    public boolean confirmReduction(int matchedNonterminalIdentifier, IParseNode[] parseNodes, int[] notWhiteIndexes, ParseSession parseSession) throws ParserException {
        boolean confirmReduction;
        IMatchMgr matchMgr = this.matchMgrs[matchedNonterminalIdentifier - 65536];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("match manager is " + matchMgr));
        }
        if (matchMgr == null) {
            confirmReduction = true;
        } else {
            try {
                confirmReduction = matchMgr.confirmReduction(parseSession, parseNodes, notWhiteIndexes);
            }
            catch (ParserException exception) {
                throw exception;
            }
            catch (Exception exception) {
                confirmReduction = false;
                String title = "doing confirm reduce";
                this.matchMgrError(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, exception, "doing confirm reduce");
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(confirmReduction ? "reduction confirmed" : "reduction cancelled"));
        }
        return confirmReduction;
    }

    public void reduceAction(int matchedNonterminalIdentifier, IParseNode fatherParseNode, IParseNode[] parseNodes, int[] notWhiteIndexes, ParseSession parseSession) throws ParserException {
        try {
            if (_log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                this.parseNodesToString(builder, matchedNonterminalIdentifier, parseNodes, notWhiteIndexes);
                _log.debug((Object)builder.toString());
            }
            IMatchMgr matchMgr = this.matchMgrs[matchedNonterminalIdentifier - 65536];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("match manager is " + matchMgr));
            }
            fatherParseNode.setMatchMgr(matchMgr);
            if (matchMgr != null && !this.skipReduceAfterError) {
                try {
                    matchMgr.reduceAction(parseSession, fatherParseNode, parseNodes, notWhiteIndexes);
                }
                catch (ParserException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    String title = "doing reduce action";
                    this.matchMgrError(matchedNonterminalIdentifier, parseNodes, notWhiteIndexes, exception, "doing reduce action");
                }
            }
            if (_log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("reduced to:\n");
                this.parseNodeToString(builder, fatherParseNode);
                _log.debug((Object)builder.toString());
            }
        }
        catch (RuntimeException exception) {
            StringBuilder builder = new StringBuilder();
            builder.append("runtime exception\n");
            this.parseNodesToString(builder, matchedNonterminalIdentifier, parseNodes, notWhiteIndexes);
            _log.error((Object)builder.toString(), (Throwable)exception);
            throw exception;
        }
    }

    private void matchMgrError(int matchedNonterminalIdentifier, IParseNode[] parseNodes, int[] notWhiteIndexes, Exception exception, String title) {
        StringBuilder builder = new StringBuilder();
        builder.append(title);
        builder.append('\n');
        this.parseNodesToString(builder, matchedNonterminalIdentifier, parseNodes, notWhiteIndexes);
        String message = builder.toString();
        _log.error((Object)message, (Throwable)exception);
        this.reduceException = new ParserException(message, exception);
        this.skipReduceAfterError = true;
    }

    private void parseNodesToString(StringBuilder builder, int matchedNonterminalIdentifier, IParseNode[] parseNodes, int[] notWhiteIndexes) {
        IParseNode parseNode;
        builder.append(this.parsingToStringUtil.grammarSymbolIdentifierToString(matchedNonterminalIdentifier));
        builder.append(" <-");
        Object[] objectArray = parseNodes;
        int n = parseNodes.length;
        int n2 = 0;
        while (n2 < n) {
            parseNode = objectArray[n2];
            builder.append(' ');
            builder.append(this.parsingToStringUtil.grammarSymbolIdentifierToString(parseNode.getGrammarSymbolIdentifier()));
            ++n2;
        }
        builder.append("\nnot white space ");
        objectArray = notWhiteIndexes;
        n = notWhiteIndexes.length;
        n2 = 0;
        while (n2 < n) {
            IParseNode nwi = objectArray[n2];
            builder.append((int)nwi);
            builder.append(' ');
            ++n2;
        }
        builder.append('\n');
        objectArray = parseNodes;
        n = parseNodes.length;
        n2 = 0;
        while (n2 < n) {
            parseNode = objectArray[n2];
            this.parseNodeToString(builder, parseNode);
            builder.append('\n');
            ++n2;
        }
    }

    private void parseNodeToString(StringBuilder builder, IParseNode parseNode) {
        builder.append(this.parsingToStringUtil.grammarSymbolIdentifierToString(parseNode.getGrammarSymbolIdentifier()));
        builder.append(": ");
        builder.append((Object)parseNode.getParseNodeType());
        builder.append(", ");
        builder.append(parseNode.getClass().getSimpleName());
        if (parseNode.isNonTerminal()) {
            builder.append(", match mgr ");
            IMatchMgr matchMgr = parseNode.getMatchMgr();
            if (matchMgr == null) {
                builder.append("null");
            } else {
                builder.append(matchMgr.getClass().getSimpleName());
            }
            builder.append(",");
            IParseNodeData[] dataByAlternative = parseNode.getDataByAlternative();
            int index = 0;
            IParseNodeData[] iParseNodeDataArray = dataByAlternative;
            int n = dataByAlternative.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNodeData parseNodeData = iParseNodeDataArray[n2];
                builder.append(" data #");
                builder.append(index);
                builder.append(": ");
                if (parseNodeData == null) {
                    builder.append("null");
                } else {
                    builder.append(parseNodeData.getClass().getSimpleName());
                }
                ++index;
                ++n2;
            }
            if (parseNode.isWhiteSpace()) {
                builder.append(", is white space");
            } else {
                builder.append(", is not white space");
            }
        }
    }
}

