/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.parsestate;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeInErrorStatus;
import net.sf.parser4j.parser.entity.parsestate.ParseStackElement;

public class ParseStack
implements Comparable<ParseStack> {
    private Deque<ParseStackElement> parseStateNodeStack;
    private int stateNumber;
    private boolean matchAll;
    private IParseNode matchAllParseNode;
    private transient IParseNodeInErrorStatus parseNodeInErrorStatus;
    private transient int[] notWhiteIndexes;

    public ParseStack() {
        this.parseStateNodeStack = new LinkedList<ParseStackElement>();
        this.stateNumber = 0;
    }

    public ParseStack(int stateNumber) {
        this.parseStateNodeStack = new LinkedList<ParseStackElement>();
        this.stateNumber = stateNumber;
    }

    public ParseStack(Deque<ParseStackElement> parseStateNodeStack, int stateNumber) {
        this.parseStateNodeStack = parseStateNodeStack;
        this.stateNumber = stateNumber;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public Deque<ParseStackElement> getParseStateNodeStack() {
        return this.parseStateNodeStack;
    }

    public void shift(IParseNode parseNode, int toState) {
        ParseStackElement parseStackElement = new ParseStackElement(parseNode, this.stateNumber);
        this.parseStateNodeStack.addLast(parseStackElement);
        this.stateNumber = toState;
    }

    public IParseNode[] getMatchedParseNode(int matchedLength) {
        Iterator<ParseStackElement> iterator = this.parseStateNodeStack.descendingIterator();
        LinkedList<IParseNode> deque = new LinkedList<IParseNode>();
        LinkedList<Integer> notWhiteIndexList = new LinkedList<Integer>();
        int index = 0;
        while (index < matchedLength) {
            IParseNode parseNode = iterator.next().getParseNode();
            deque.addFirst(parseNode);
            if (parseNode.isInError()) {
                this.parseNodeInErrorStatus = parseNode.getErrorStatus();
            }
            if (!parseNode.isWhiteSpace()) {
                notWhiteIndexList.addFirst(matchedLength - index - 1);
            }
            ++index;
        }
        IParseNode[] parseNodes = new IParseNode[matchedLength];
        deque.toArray(parseNodes);
        this.notWhiteIndexes = new int[notWhiteIndexList.size()];
        int index2 = 0;
        Iterator iterator2 = notWhiteIndexList.iterator();
        while (iterator2.hasNext()) {
            int notWhiteIndex = (Integer)iterator2.next();
            this.notWhiteIndexes[index2++] = notWhiteIndex;
        }
        return parseNodes;
    }

    public IParseNodeInErrorStatus getParseNodeInErrorStatus() {
        return this.parseNodeInErrorStatus;
    }

    public int[] getNotWhiteIndexes() {
        return this.notWhiteIndexes;
    }

    public IParseNode[] getParseNode() {
        IParseNode[] parseNodes = new IParseNode[this.parseStateNodeStack.size()];
        int index = 0;
        for (ParseStackElement parseStackElement : this.parseStateNodeStack) {
            parseNodes[index] = parseStackElement.getParseNode();
            ++index;
        }
        return parseNodes;
    }

    public ParseStack copy() {
        LinkedList<ParseStackElement> parseStackCopy = new LinkedList<ParseStackElement>(this.parseStateNodeStack);
        return new ParseStack(parseStackCopy, this.stateNumber);
    }

    public void reduce(int matchedLength) {
        if (matchedLength != 0) {
            int count = 0;
            while (count < matchedLength - 1) {
                this.parseStateNodeStack.pollLast();
                ++count;
            }
            this.stateNumber = this.parseStateNodeStack.pollLast().getStateNumber();
        }
    }

    public void setMatchAll(IParseNode matchAllParseNode) {
        this.matchAll = true;
        this.matchAllParseNode = matchAllParseNode;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public IParseNode getMatchAllParseNode() {
        return this.matchAllParseNode;
    }

    @Override
    public int compareTo(ParseStack parseStack) {
        int compareTo = this.parseStateNodeStack.size() - parseStack.parseStateNodeStack.size();
        if (compareTo == 0) {
            Iterator<ParseStackElement> iterator = this.parseStateNodeStack.iterator();
            Iterator<ParseStackElement> iteratorOnOther = parseStack.parseStateNodeStack.iterator();
            while (compareTo == 0 && iterator.hasNext() && iteratorOnOther.hasNext()) {
                ParseStackElement next = iterator.next();
                ParseStackElement otherNext = iteratorOnOther.next();
                compareTo = next.getStateNumber() - otherNext.getStateNumber();
                if (compareTo != 0) continue;
                IParseNode nextParseNode = next.getParseNode();
                IParseNode otherNextParseNode = otherNext.getParseNode();
                compareTo = nextParseNode.getGrammarSymbolIdentifier() - otherNextParseNode.getGrammarSymbolIdentifier();
            }
            if (compareTo == 0) {
                compareTo = this.getStateNumber() - parseStack.getStateNumber();
            }
        }
        return compareTo;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (ParseStackElement parseStackElement : this.parseStateNodeStack) {
            result = 31 * result + parseStackElement.getStateNumber();
            result = 31 * result + parseStackElement.getParseNode().hashCode();
        }
        result = 31 * result + this.getStateNumber();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParseStack other = (ParseStack)obj;
        return this.compareTo(other) == 0;
    }
}

