/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.parsestate;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsestate.IParseState;
import net.sf.parser4j.parser.entity.parsestate.ParseStack;
import net.sf.parser4j.parser.entity.parsestate.ParseState;
import net.sf.parser4j.parser.service.HasAmbiguityParserException;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import net.sf.parser4j.parser.service.parsenode.TooMuchAlternativeParserException;
import org.apache.log4j.Logger;

public abstract class AbstractParseState
implements IParseState {
    protected final Logger _log = Logger.getLogger(this.getClass());
    protected static final ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();
    protected final boolean acceptAmbiguity;
    protected final Map<ParseStack, ParseStack> parseStackSet = new TreeMap<ParseStack, ParseStack>();
    private boolean alternativeForAmbiguity = false;
    protected final boolean[] tokenRecognition;
    protected int maxNumberOfAlternative;

    public AbstractParseState(boolean acceptAmbiguity, int maxNumberOfAlternative, boolean[] tokenRecognition) {
        this.acceptAmbiguity = acceptAmbiguity;
        this.maxNumberOfAlternative = maxNumberOfAlternative;
        this.tokenRecognition = tokenRecognition;
    }

    @Override
    public boolean add(ParseStack parseStack) throws ParserException, HasAmbiguityParserException {
        boolean added;
        ParseStack existingParseStack = this.parseStackSet.get(parseStack);
        if (existingParseStack == null) {
            this.parseStackSet.put(parseStack, parseStack);
            added = true;
            if (this._log.isDebugEnabled()) {
                String toString = parsingToStringUtil.parseStackToString(parseStack, this.tokenRecognition, false);
                this._log.debug((Object)("added\n" + toString));
            }
        } else {
            if (existingParseStack == parseStack) {
                throw new ParserException("add same");
            }
            if (this._log.isDebugEnabled()) {
                String toString = parsingToStringUtil.parseStackToString(existingParseStack, this.tokenRecognition, false);
                this._log.debug((Object)("set alternative for\n" + toString));
            }
            added = false;
            this.alternativeForAmbiguity = true;
            IParseNode[] existing = existingParseStack.getParseNode();
            IParseNode[] alternative = parseStack.getParseNode();
            boolean[] alternativeAddedByStackElt = new boolean[existing.length];
            int index = 0;
            boolean hasAmbiguity = false;
            IParseNode[] iParseNodeArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode existingParseNode = iParseNodeArray[n2];
                try {
                    boolean alternativeAdded;
                    alternativeAddedByStackElt[index] = alternativeAdded = existingParseNode.setAlternativeParseNode(alternative[index], this.maxNumberOfAlternative);
                    if (alternativeAdded) {
                        hasAmbiguity = true;
                    }
                }
                catch (TooMuchAlternativeParserException exception) {
                    String existingToString = parsingToStringUtil.parseStackToString(existingParseStack, this.tokenRecognition, false);
                    String message = "for element #" + index + " of\n" + existingToString;
                    throw new ParserException(message, exception);
                }
                ++index;
                ++n2;
            }
            if (hasAmbiguity && !this.acceptAmbiguity) {
                LinkedList<IParseNode> parseNodeList = new LinkedList<IParseNode>();
                StringBuilder builder = new StringBuilder();
                builder.append("alternative on stack below entry:");
                index = 0;
                boolean[] blArray = alternativeAddedByStackElt;
                int n3 = alternativeAddedByStackElt.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean a = blArray[n4];
                    if (a) {
                        builder.append(" #");
                        builder.append(index);
                        parseNodeList.add(existing[index]);
                    }
                    ++index;
                    ++n4;
                }
                builder.append('\n');
                builder.append(parsingToStringUtil.parseStackToString(parseStack, this.tokenRecognition, false));
                throw new HasAmbiguityParserException(builder.toString(), parseNodeList);
            }
        }
        return added;
    }

    @Override
    public void clear() {
        this.parseStackSet.clear();
    }

    public boolean remove(ParseStack parseStack) {
        return this.parseStackSet.remove(parseStack) != null;
    }

    public IParseNode getMatchParseNode() {
        if (this.parseStackSet.size() != 1) {
            throw new IllegalStateException("bad size " + this.parseStackSet.size() + ", 1 parse stack expected");
        }
        return this.parseStackSet.keySet().iterator().next().getMatchAllParseNode();
    }

    @Override
    public Iterator<ParseStack> iterator() {
        return this.parseStackSet.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.parseStackSet.isEmpty();
    }

    @Override
    public int size() {
        return this.parseStackSet.size();
    }

    @Override
    public ParseStack[] toArray() {
        ParseStack[] parseStacks = new ParseStack[this.parseStackSet.size()];
        this.parseStackSet.keySet().toArray(parseStacks);
        return parseStacks;
    }

    public boolean hasAlternativeForAmbiguity() {
        return this.alternativeForAmbiguity;
    }

    @Override
    public IParseState copy() {
        return new ParseState(this);
    }
}

