/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.parsenode.status.impl;

import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeInErrorStatus;
import net.sf.parser4j.parser.entity.parsenode.status.impl.AbstractParseNodeStatus;
import net.sf.parser4j.parser.entity.parsenode.status.impl.StatusSetterTrace;
import net.sf.parser4j.parser.service.DebugUtil;

public abstract class AbstractParseNodeInErrorStatus
extends AbstractParseNodeStatus
implements IParseNodeInErrorStatus {
    private static final DebugUtil debugUtil = DebugUtil.getInstance();
    private final IParseNode inErrorParseNode;
    private final StatusSetterTrace statusSetterTrace;
    private final Exception exception;

    public AbstractParseNodeInErrorStatus(IParseNode inErrorParseNode, Exception exception, StatusSetterTrace statusSetterTrace) {
        super(true);
        this.inErrorParseNode = inErrorParseNode;
        this.exception = exception;
        this.statusSetterTrace = statusSetterTrace;
    }

    public Exception getException() {
        return this.exception;
    }

    public StatusSetterTrace getStatusSetterTrace() {
        return this.statusSetterTrace;
    }

    @Override
    public int getBeginColumnNumber() {
        return this.inErrorParseNode.getBeginColumnNumber();
    }

    @Override
    public int getBeginLineNumber() {
        return this.inErrorParseNode.getBeginLineNumber();
    }

    @Override
    public int getEndColumnNumber() {
        return this.inErrorParseNode.getEndColumnNumber();
    }

    @Override
    public int getEndLineNumber() {
        return this.inErrorParseNode.getEndLineNumber();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(debugUtil.stackTrace(this.statusSetterTrace));
        if (this.exception != null) {
            stringBuilder.append("cause by:\n");
            stringBuilder.append(debugUtil.stackTrace(this.exception));
        }
        stringBuilder.append("\nat ");
        stringBuilder.append(this.getBeginLineNumber());
        stringBuilder.append(",");
        stringBuilder.append(this.getBeginColumnNumber());
        stringBuilder.append(" thru ");
        stringBuilder.append(this.getEndLineNumber());
        stringBuilder.append(",");
        stringBuilder.append(this.getEndColumnNumber());
        stringBuilder.append(": ");
        stringBuilder.append(this.getClass().getSimpleName());
        return stringBuilder.toString();
    }
}

