/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.parsenode;

import net.sf.parser4j.parser.entity.EnumNodeType;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeInErrorStatus;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeStatus;
import net.sf.parser4j.parser.entity.parsenode.status.impl.NoErrorParseNodeStatus;
import net.sf.parser4j.parser.service.match.IMatchMgr;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import org.apache.log4j.Logger;

public abstract class AbstractParseNode
implements IParseNode {
    protected transient Logger _log = Logger.getLogger(this.getClass());
    private static int nextParseNodeIdentifier = 0;
    private final int myIdentifier;
    private final EnumNodeType parseNodeType;
    private IMatchMgr matchMgr;
    private int grammarSymbolIdentifier;
    protected int beginLineNumber;
    protected int beginColumnNumber;
    protected int endLineNumber;
    protected int endColumnNumber;
    private boolean whiteSpace;
    private IParseNodeStatus status = NoErrorParseNodeStatus.getInstance();

    protected AbstractParseNode(EnumNodeType parseNodeType) {
        this.parseNodeType = parseNodeType;
        this.myIdentifier = nextParseNodeIdentifier++;
    }

    @Override
    public int getMyIdentifier() {
        return this.myIdentifier;
    }

    @Override
    public EnumNodeType getParseNodeType() {
        return this.parseNodeType;
    }

    @Override
    public int getGrammarSymbolIdentifier() {
        return this.grammarSymbolIdentifier;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.whiteSpace;
    }

    @Override
    public void setWhiteSpace(boolean whiteSpace) {
        this.whiteSpace = whiteSpace;
    }

    @Override
    public IMatchMgr getMatchMgr() {
        return this.matchMgr;
    }

    @Override
    public void setMatchMgr(IMatchMgr matchMgr) {
        this.matchMgr = matchMgr;
    }

    @Override
    public boolean isNonTerminal() {
        return this.parseNodeType.isNonTerminal();
    }

    @Override
    public boolean isTerminal() {
        return this.parseNodeType.isTerminal();
    }

    @Override
    public void setGrammarSymbolIdentifier(int grammarSymbolIdentifier) {
        this.grammarSymbolIdentifier = grammarSymbolIdentifier;
    }

    @Override
    public void setLineAndColumnNumber(int beginLineNumber, int beginColumnNumber, int endLineNumber, int endColumnNumber) {
        this.beginLineNumber = beginLineNumber;
        this.beginColumnNumber = beginColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    @Override
    public int getBeginLineNumber() {
        return this.beginLineNumber;
    }

    @Override
    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    @Override
    public int getBeginColumnNumber() {
        return this.beginColumnNumber;
    }

    @Override
    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    @Override
    public boolean isInError() {
        return this.status.isInError();
    }

    @Override
    public IParseNodeInErrorStatus getErrorStatus() {
        return (IParseNodeInErrorStatus)this.status;
    }

    @Override
    public void setErrorStatus(IParseNodeInErrorStatus status) {
        this.status = status;
    }

    public String toString() {
        throw new UnsupportedOperationException(this.getClass() + ", use " + ParsingToStringUtil.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.grammarSymbolIdentifier;
        result = 31 * result + (this.parseNodeType == null ? 0 : this.parseNodeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractParseNode other = (AbstractParseNode)obj;
        if (this.grammarSymbolIdentifier != other.grammarSymbolIdentifier) {
            return false;
        }
        return !(this.parseNodeType == null ? other.parseNodeType != null : !this.parseNodeType.equals((Object)other.parseNodeType));
    }
}

