/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.parsenode;

import java.util.Arrays;
import net.sf.parser4j.parser.entity.EnumNodeType;
import net.sf.parser4j.parser.entity.parsenode.AbstractParseNode;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.data.IParseNodeData;
import net.sf.parser4j.parser.entity.parsenode.data.NullParseNodeData;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.parsenode.IParseNodeVisitor;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;
import net.sf.parser4j.parser.service.parsenode.TooMuchAlternativeParserException;

public abstract class AbstractNonTerminalParseNode
extends AbstractParseNode {
    private static final ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();
    private int numberOfAlternative;
    protected IParseNode[][] sonParseNodesByAlternative;
    private IParseNodeData[] dataByAlternative;

    public AbstractNonTerminalParseNode(EnumNodeType parseNodeType) {
        super(parseNodeType);
    }

    public AbstractNonTerminalParseNode(EnumNodeType parseNodeType, IParseNode[] parseNodes) {
        super(parseNodeType);
        this.sonParseNodesByAlternative = new IParseNode[1][];
        this.sonParseNodesByAlternative[0] = parseNodes;
        this.dataByAlternative = new IParseNodeData[1];
        this.dataByAlternative[0] = NullParseNodeData.getInstance();
        this.numberOfAlternative = 1;
    }

    @Override
    public int getNumberOfAlternative() {
        return this.numberOfAlternative;
    }

    @Override
    public IParseNode[][] getSonParseNodesByAlternative() {
        return this.sonParseNodesByAlternative;
    }

    @Override
    public boolean setAlternativeParseNode(IParseNode alternativeParseNode, int maxNumberOfAlternative) throws ParserException, TooMuchAlternativeParserException {
        boolean added;
        if (alternativeParseNode == this) {
            added = false;
        } else {
            added = true;
            int numberOfNewAlternative = alternativeParseNode.getNumberOfAlternative();
            IParseNode[][] newAlternativeSons = alternativeParseNode.getSonParseNodesByAlternative();
            IParseNodeData[] newAlternativeData = alternativeParseNode.getDataByAlternative();
            int newNumberOfAlternative = this.numberOfAlternative + numberOfNewAlternative;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("for " + ParsingToStringUtil.getInstance().parseNodeToString(alternativeParseNode) + "\nnumber of alternative: old=" + this.numberOfAlternative + ", new=" + newNumberOfAlternative + ", new alternative=" + numberOfNewAlternative));
            }
            if (newNumberOfAlternative <= maxNumberOfAlternative) {
                this.sonParseNodesByAlternative = (IParseNode[][])Arrays.copyOf(this.sonParseNodesByAlternative, newNumberOfAlternative);
                this.dataByAlternative = Arrays.copyOf(this.dataByAlternative, newNumberOfAlternative);
                int destIndex = this.numberOfAlternative;
                int srcIndex = 0;
                while (srcIndex < numberOfNewAlternative) {
                    this.sonParseNodesByAlternative[destIndex] = newAlternativeSons[srcIndex];
                    this.dataByAlternative[destIndex] = newAlternativeData[srcIndex];
                    ++destIndex;
                    ++srcIndex;
                }
                this.numberOfAlternative = newNumberOfAlternative;
            } else {
                String thisParseNode = parsingToStringUtil.parseTreeToString(this);
                String altParseNode = parsingToStringUtil.parseTreeToString(alternativeParseNode);
                String message = "to add to\n" + thisParseNode + "\nalternative\n" + altParseNode;
                throw new TooMuchAlternativeParserException(message);
            }
        }
        return added;
    }

    @Override
    public IParseNodeData getUniqData() {
        if (this.numberOfAlternative != 1) {
            throw new IllegalStateException("have multiple alternative");
        }
        return this.dataByAlternative[0];
    }

    @Override
    public IParseNodeData[] getDataByAlternative() {
        return this.dataByAlternative;
    }

    @Override
    public void setData(IParseNodeData data) {
        if (data == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.numberOfAlternative != 1) {
            throw new IllegalStateException("have multiple alternative");
        }
        this.dataByAlternative[0] = data;
    }

    protected void setSonParseNodes(IParseNode[] array) {
        this.sonParseNodesByAlternative[0] = array;
    }

    @Override
    public void accept(IParseNodeVisitor visitor) {
        if (visitor.beginVisit(this)) {
            if (visitor.visitFirstAlternativeOnly()) {
                IParseNode[] sonParseNodes = this.sonParseNodesByAlternative[0];
                visitor.beginAlternativeVisit(this, 0);
                IParseNode[] iParseNodeArray = sonParseNodes;
                int n = sonParseNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode parseNode = iParseNodeArray[n2];
                    parseNode.accept(visitor);
                    ++n2;
                }
                visitor.endAlternativeVisit(this, 0);
            } else {
                int alternativeCount = 0;
                IParseNode[][] iParseNodeArray = this.sonParseNodesByAlternative;
                int n = this.sonParseNodesByAlternative.length;
                int n3 = 0;
                while (n3 < n) {
                    IParseNode[] sonParseNodes = iParseNodeArray[n3];
                    visitor.beginAlternativeVisit(this, alternativeCount);
                    IParseNode[] iParseNodeArray2 = sonParseNodes;
                    int n4 = sonParseNodes.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IParseNode parseNode = iParseNodeArray2[n5];
                        parseNode.accept(visitor);
                        ++n5;
                    }
                    visitor.endAlternativeVisit(this, alternativeCount);
                    ++alternativeCount;
                    ++n3;
                }
            }
            visitor.endVisit(this);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        int index = 0;
        while (index < this.numberOfAlternative) {
            result = 31 * result + Arrays.hashCode(this.sonParseNodesByAlternative[index]);
            ++index;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractNonTerminalParseNode)) {
            return false;
        }
        AbstractNonTerminalParseNode other = (AbstractNonTerminalParseNode)obj;
        if (this.numberOfAlternative != other.numberOfAlternative) {
            return false;
        }
        int index = 0;
        while (index < this.numberOfAlternative) {
            if (!Arrays.equals(this.sonParseNodesByAlternative[index], other.sonParseNodesByAlternative[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

