/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.data;

import java.io.Serializable;

public class TerminalCharRange
implements Comparable<TerminalCharRange>,
Serializable {
    private static final long serialVersionUID = 2048555852029234910L;
    private final int firstTerminalValue;
    private final int lastTerminalValue;

    public TerminalCharRange(int firstTerminalValue, int lastTerminalValue) {
        if (firstTerminalValue > lastTerminalValue) {
            throw new IllegalArgumentException("first value is greater than last value");
        }
        this.firstTerminalValue = firstTerminalValue;
        this.lastTerminalValue = lastTerminalValue;
    }

    public int getFirstTerminalValue() {
        return this.firstTerminalValue;
    }

    public int getLastTerminalValue() {
        return this.lastTerminalValue;
    }

    @Override
    public int compareTo(TerminalCharRange terminalCharRange) {
        int compareTo = this.lastTerminalValue < terminalCharRange.firstTerminalValue ? -1 : (this.firstTerminalValue > terminalCharRange.getLastTerminalValue() ? 1 : 0);
        return compareTo;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.firstTerminalValue;
        result = 31 * result + this.lastTerminalValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalCharRange other = (TerminalCharRange)obj;
        if (this.firstTerminalValue != other.firstTerminalValue) {
            return false;
        }
        return this.lastTerminalValue == other.lastTerminalValue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.firstTerminalValue < 32 || this.firstTerminalValue >= 127) {
            stringBuilder.append("0X");
            stringBuilder.append(Integer.toString(this.firstTerminalValue, 16));
        } else {
            stringBuilder.append('\'');
            stringBuilder.append((char)this.firstTerminalValue);
            stringBuilder.append('\'');
        }
        stringBuilder.append(" - ");
        if (this.lastTerminalValue < 32 || this.lastTerminalValue >= 127) {
            stringBuilder.append("0X");
            stringBuilder.append(Integer.toString(this.lastTerminalValue, 16));
        } else {
            stringBuilder.append('\'');
            stringBuilder.append((char)this.lastTerminalValue);
            stringBuilder.append('\'');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

