/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.parser4j.parser.entity.data.GotoByNonTerminalEntry;
import net.sf.parser4j.parser.entity.data.GotoByTerminalEntry;
import net.sf.parser4j.parser.entity.data.MatchEntry;
import net.sf.parser4j.parser.entity.data.MatchEntrySet;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import net.sf.parser4j.parser.entity.data.ParserDataRecognitionPoint;
import net.sf.parser4j.parser.entity.data.StateRecognitionPointList;
import net.sf.parser4j.parser.entity.data.TerminalCharRange;
import net.sf.parser4j.parser.entity.data.ToStateAndWhiteSpaceFlag;
import net.sf.parser4j.parser.service.ExStringBuilder;

public class ParserData
implements Serializable {
    private static final long serialVersionUID = 2384785354559121747L;
    private final int numberOfState;
    private final int numberOfNonterminal;
    private GotoByTerminalEntry[] gotoByTerminalTable;
    private GotoByTerminalEntry[] tokenGotoByTerminalTable;
    private GotoByNonTerminalEntry[] gotoByNonTerminalTable;
    private GotoByNonTerminalEntry[] tokenGotoByNonTerminalTable;
    private MatchEntrySet[] matchTable;
    private MatchEntrySet[] tokenMatchTable;
    private boolean[] tokenRecognition;
    private String[] matchClassNameTable;
    private int rootNonTerminalIdentifier;
    private Map<Integer, NonTerminal> nonTerminalByIdentifierMap;
    private StateRecognitionPointList[] byStateRecognitionPointList;

    public ParserData(int numberOfState, int numberOfNonterminal) {
        this.numberOfState = numberOfState;
        this.numberOfNonterminal = numberOfNonterminal;
        this.gotoByTerminalTable = new GotoByTerminalEntry[numberOfState];
        this.tokenGotoByTerminalTable = new GotoByTerminalEntry[numberOfState];
        this.gotoByNonTerminalTable = new GotoByNonTerminalEntry[numberOfState];
        this.tokenGotoByNonTerminalTable = new GotoByNonTerminalEntry[numberOfState];
        this.matchTable = new MatchEntrySet[numberOfState];
        this.tokenMatchTable = new MatchEntrySet[numberOfState];
        this.tokenRecognition = new boolean[numberOfState];
        this.byStateRecognitionPointList = new StateRecognitionPointList[numberOfState];
        int stateIdentifier = 0;
        while (stateIdentifier < numberOfState) {
            this.gotoByTerminalTable[stateIdentifier] = new GotoByTerminalEntry();
            this.tokenGotoByTerminalTable[stateIdentifier] = new GotoByTerminalEntry();
            this.gotoByNonTerminalTable[stateIdentifier] = new GotoByNonTerminalEntry();
            this.tokenGotoByNonTerminalTable[stateIdentifier] = new GotoByNonTerminalEntry();
            this.matchTable[stateIdentifier] = new MatchEntrySet(false);
            this.tokenMatchTable[stateIdentifier] = new MatchEntrySet(true);
            this.tokenRecognition[stateIdentifier] = false;
            ++stateIdentifier;
        }
        this.matchClassNameTable = new String[numberOfNonterminal];
    }

    public int getNumberOfNonterminal() {
        return this.numberOfNonterminal;
    }

    public int getNumberOfState() {
        return this.numberOfState;
    }

    public void addGotoByTerminal(boolean token, int fromStateIdentifier, TerminalCharRange terminalCharRange, int toStateIdentifier) {
        if (token) {
            this.tokenGotoByTerminalTable[fromStateIdentifier].addGoto(terminalCharRange, toStateIdentifier);
        } else {
            this.gotoByTerminalTable[fromStateIdentifier].addGoto(terminalCharRange, toStateIdentifier);
        }
    }

    public void addGotoByNonTerminal(boolean token, int fromStateIdentifier, int nonTerminalIdentifier, ToStateAndWhiteSpaceFlag toStateAndWhiteSpaceFlag) {
        if (token) {
            this.tokenGotoByNonTerminalTable[fromStateIdentifier].addGoto(nonTerminalIdentifier, toStateAndWhiteSpaceFlag);
        } else {
            this.gotoByNonTerminalTable[fromStateIdentifier].addGoto(nonTerminalIdentifier, toStateAndWhiteSpaceFlag);
        }
    }

    public void addMatch(int fromStateIdentifier, int nonTerminalIdentifier, int length, int nodeType, boolean token) {
        this.matchTable[fromStateIdentifier].addMatch(nonTerminalIdentifier, length, nodeType, token);
    }

    public void addTokenMatch(int fromStateIdentifier, int nonTerminalIdentifier, int length, int nodeType, boolean token) {
        this.tokenMatchTable[fromStateIdentifier].addMatch(nonTerminalIdentifier, length, nodeType, token);
    }

    public void setTokenRecognition(int stateIdentifier) {
        this.tokenRecognition[stateIdentifier] = true;
    }

    public boolean[] getTokenRecognition() {
        return this.tokenRecognition;
    }

    public void setNonTerminalMatchClassName(int nonTerminalIdentifier, String matchClassName) {
        this.matchClassNameTable[nonTerminalIdentifier - 65536] = matchClassName;
    }

    public boolean match(int stateIdentifier) {
        return this.matchTable[stateIdentifier].match();
    }

    public GotoByTerminalEntry[] getGotoByTerminalTable() {
        return this.gotoByTerminalTable;
    }

    public GotoByTerminalEntry[] getTokenGotoByTerminalTable() {
        return this.tokenGotoByTerminalTable;
    }

    public GotoByNonTerminalEntry[] getGotoByNonTerminalTable() {
        return this.gotoByNonTerminalTable;
    }

    public GotoByNonTerminalEntry[] getTokenGotoByNonTerminalTable() {
        return this.tokenGotoByNonTerminalTable;
    }

    public String[] getMatchClassNameTable() {
        return this.matchClassNameTable;
    }

    public MatchEntrySet[] getMatchTable() {
        return this.matchTable;
    }

    public MatchEntrySet[] getTokenMatchTable() {
        return this.tokenMatchTable;
    }

    public int getRootNonTerminalIdentifier() {
        return this.rootNonTerminalIdentifier;
    }

    public void setRootNonTerminalIdentifier(int rootNonTerminalIdentifier) {
        this.rootNonTerminalIdentifier = rootNonTerminalIdentifier;
    }

    public void setNonTerminalByIdentifierMap(Map<Integer, NonTerminal> nonTerminalByIdentifierMap) {
        this.nonTerminalByIdentifierMap = nonTerminalByIdentifierMap;
    }

    public Map<Integer, NonTerminal> getNonTerminalByIdentifierMap() {
        return this.nonTerminalByIdentifierMap;
    }

    public void setRecognitionPoint(int stateIdentifier, List<ParserDataRecognitionPoint> list) {
        this.byStateRecognitionPointList[stateIdentifier] = new StateRecognitionPointList(list);
    }

    public List<ParserDataRecognitionPoint> getRecognitionPoint(int stateIdentifier) {
        return this.byStateRecognitionPointList[stateIdentifier].getList();
    }

    public StateRecognitionPointList[] getByStateRecognitionPointList() {
        return this.byStateRecognitionPointList;
    }

    public String toString() {
        ExStringBuilder builder = new ExStringBuilder();
        int stateIdentifier = 0;
        while (stateIdentifier < this.numberOfState) {
            builder.append("\nstate #");
            builder.append(stateIdentifier);
            builder.append("\n\ngoto by terminal:\n");
            GotoByTerminalEntry gotoByTerminalEntry = this.gotoByTerminalTable[stateIdentifier];
            builder.appendTabulate(1, gotoByTerminalEntry.toString());
            builder.append("\ngoto by non terminal:\n");
            Map<Integer, ToStateAndWhiteSpaceFlag> gotoMap = this.gotoByNonTerminalTable[stateIdentifier].getGotoMap();
            for (Map.Entry<Integer, ToStateAndWhiteSpaceFlag> entry : gotoMap.entrySet()) {
                ToStateAndWhiteSpaceFlag value;
                builder.append("\tby ");
                NonTerminal nonTerminal = this.nonTerminalByIdentifierMap.get(entry.getKey());
                builder.append(nonTerminal.getName());
                if (nonTerminal.isToken()) {
                    builder.append(" (token)");
                }
                if ((value = entry.getValue()).isWhiteSpace()) {
                    builder.append(" (as white space)");
                }
                builder.append(" goto ");
                builder.append(value.getToState());
                builder.append('\n');
            }
            builder.append("\nmatch:\n");
            Set<MatchEntry> set = this.matchTable[stateIdentifier].getNonTerminalMatchSet();
            for (MatchEntry matchEntry : set) {
                int identifier = matchEntry.getMatchedNonTerminalIdentifier();
                builder.append('\t');
                NonTerminal nonTerminal = this.nonTerminalByIdentifierMap.get(identifier);
                builder.append(nonTerminal.getName());
                if (nonTerminal.isToken()) {
                    builder.append(" (token)");
                }
                builder.append('\n');
            }
            builder.append('\n');
            StateRecognitionPointList stateRecognitionPointList = this.byStateRecognitionPointList[stateIdentifier];
            List<ParserDataRecognitionPoint> list = stateRecognitionPointList.getList();
            for (ParserDataRecognitionPoint recognitionPoint : list) {
                int identifier = recognitionPoint.getDefinedNonTerminalIdentifier();
                String name = this.nonTerminalByIdentifierMap.get(identifier).getName();
                boolean token = recognitionPoint.isToken();
                if (token) {
                    builder.append('[');
                }
                builder.append(name);
                if (token) {
                    builder.append(']');
                }
                builder.append(':');
                int recognitionPointIndex = recognitionPoint.getRecognitionPointIndex();
                int[] rightPart = recognitionPoint.getRightPart();
                boolean concat = recognitionPoint.isConcat();
                int index = 0;
                int[] nArray = rightPart;
                int n = rightPart.length;
                int n2 = 0;
                while (n2 < n) {
                    int rightIdentifier = nArray[n2];
                    builder.append(' ');
                    if (!concat || index == recognitionPointIndex) {
                        builder.append('.');
                    }
                    if (rightIdentifier == -1) {
                        builder.append("<terminal>");
                    } else {
                        name = this.nonTerminalByIdentifierMap.get(rightIdentifier).getName();
                        builder.append(name);
                        if (!concat && index != rightPart.length - 1) {
                            builder.append(" |");
                        }
                    }
                    ++index;
                    ++n2;
                }
                if (index == recognitionPointIndex) {
                    builder.append(" .");
                }
                builder.append('\n');
            }
            ++stateIdentifier;
        }
        return builder.toString();
    }
}

