/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.data;

import java.util.Map;
import java.util.TreeMap;
import net.sf.parser4j.kernelgenerator.service.GeneratorException;
import net.sf.parser4j.parser.entity.data.NonTerminal;
import org.apache.log4j.Logger;

public class NonTerminalMap {
    private static final Logger _log = Logger.getLogger(NonTerminalMap.class);
    private int nextFreeNonTerminalIdentifier = 65536;
    private final Map<String, Integer> nonTerminalIdentifierByNameMap = new TreeMap<String, Integer>();
    private final transient Map<String, Exception> creatorTraceMap = new TreeMap<String, Exception>();
    private final Map<Integer, NonTerminal> nonTerminalByIdentifierMap = new TreeMap<Integer, NonTerminal>();
    private final Map<Integer, String> nonTerminalMatchClassSimpleNameByIdentifier = new TreeMap<Integer, String>();

    public int createNonTerminalIdentifier(String optionnalNonTerminalName, String matchClassName, boolean token) throws GeneratorException {
        String nonTerminalName;
        if (optionnalNonTerminalName == null) {
            nonTerminalName = "NT" + (this.nextFreeNonTerminalIdentifier + 1);
            _log.warn((Object)"terminal name have default value", (Throwable)new Exception("-trace-"));
        } else {
            if (optionnalNonTerminalName.startsWith("NT")) {
                _log.warn((Object)("bad name " + optionnalNonTerminalName + " start with 'NT'"), (Throwable)new Exception("-trace-"));
            }
            nonTerminalName = optionnalNonTerminalName;
        }
        if (nonTerminalName == null) {
            throw new IllegalArgumentException();
        }
        if (nonTerminalName.startsWith("null")) {
            throw new IllegalArgumentException(nonTerminalName);
        }
        Integer nonTerminalIdentifier = this.nonTerminalIdentifierByNameMap.get(nonTerminalName);
        if (nonTerminalIdentifier != null) {
            throw new GeneratorException("'" + nonTerminalName + "' already associated to identifier " + nonTerminalIdentifier, (Throwable)this.creatorTraceMap.get(nonTerminalName));
        }
        this.creatorTraceMap.put(nonTerminalName, new Exception("last creator"));
        nonTerminalIdentifier = this.nextFreeNonTerminalIdentifier++;
        this.nonTerminalIdentifierByNameMap.put(nonTerminalName, nonTerminalIdentifier);
        NonTerminal nonTerminal = new NonTerminal(nonTerminalIdentifier, nonTerminalName, token);
        this.nonTerminalByIdentifierMap.put(nonTerminalIdentifier, nonTerminal);
        this.nonTerminalMatchClassSimpleNameByIdentifier.put(nonTerminalIdentifier, matchClassName);
        return nonTerminalIdentifier;
    }

    public int getNonTerminalIdentifier(String nonTerminalName) {
        return this.nonTerminalIdentifierByNameMap.get(nonTerminalName);
    }

    public int numberOfNonterminal() {
        return this.nextFreeNonTerminalIdentifier - 65536;
    }

    public NonTerminal nonTerminalName(int nonTerminalIdentifier) {
        return this.nonTerminalByIdentifierMap.get(nonTerminalIdentifier);
    }

    public String nonTerminalMatchClassSimpleName(int nonTerminalIdentifier) {
        return this.nonTerminalMatchClassSimpleNameByIdentifier.get(nonTerminalIdentifier);
    }

    public Map<Integer, NonTerminal> getNonTerminalByIdentifierMap() {
        return this.nonTerminalByIdentifierMap;
    }
}

