/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity.data;

import java.io.Serializable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import net.sf.parser4j.parser.entity.data.TerminalCharRange;

public class GotoByTerminalEntry
implements Serializable {
    private static final long serialVersionUID = 3763559404897228094L;
    private final NavigableMap<Integer, TerminalCharRange> lowerEndMap = new TreeMap<Integer, TerminalCharRange>();
    private final Map<TerminalCharRange, Integer> gotoMap = new TreeMap<TerminalCharRange, Integer>();

    public void addGoto(TerminalCharRange terminalCharRange, int toStateIdentifier) {
        this.lowerEndMap.put(terminalCharRange.getFirstTerminalValue(), terminalCharRange);
        this.gotoMap.put(terminalCharRange, toStateIdentifier);
    }

    public int toState(int terminal) {
        TerminalCharRange value;
        Map.Entry<Integer, TerminalCharRange> entry = this.lowerEndMap.floorEntry(terminal);
        int toState = entry == null ? -1 : ((value = entry.getValue()).getFirstTerminalValue() <= terminal && value.getLastTerminalValue() >= terminal ? this.gotoMap.get(value) : -1);
        return toState;
    }

    public Set<TerminalCharRange> expected() {
        return this.gotoMap.keySet();
    }

    public Map<TerminalCharRange, Integer> getGotoMap() {
        return this.gotoMap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<TerminalCharRange, Integer> entry : this.gotoMap.entrySet()) {
            TerminalCharRange terminalCharRange = entry.getKey();
            builder.append("by (");
            builder.append(terminalCharRange.getFirstTerminalValue());
            builder.append(',');
            builder.append(terminalCharRange.getLastTerminalValue());
            builder.append(") goto ");
            builder.append(entry.getValue());
            builder.append('\n');
        }
        return builder.toString();
    }
}

