/*
 * Decompiled with CFR 0.152.
 */
package net.sf.parser4j.parser.entity;

import java.util.Set;
import java.util.TreeSet;
import net.sf.parser4j.parser.entity.data.TerminalCharRange;
import net.sf.parser4j.parser.entity.parsenode.IParseNode;
import net.sf.parser4j.parser.entity.parsenode.data.IParseNodeData;
import net.sf.parser4j.parser.entity.parsenode.status.IParseNodeInErrorStatus;
import net.sf.parser4j.parser.entity.parsestate.ParseStack;
import net.sf.parser4j.parser.service.DebugUtil;
import net.sf.parser4j.parser.service.ParserException;
import net.sf.parser4j.parser.service.parsenode.ParsingToStringUtil;

public class ParseResult {
    private static final ParsingToStringUtil parsingToStringUtil = ParsingToStringUtil.getInstance();
    private final boolean inError;
    private boolean parseError;
    private boolean reduceError;
    private String fileName;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private int lastTerminalValueReaded = -1;
    private final Set<TerminalCharRange> expectedTerminal = new TreeSet<TerminalCharRange>();
    private final Set<String> expectedNonTerminal = new TreeSet<String>();
    private ParserException reduceException;
    private IParseNodeInErrorStatus parseNodeInErrorStatus;
    private String reduceErrorFileName;
    private int reduceErrorLineNumber;
    private int reduceErrorColumnNumber;
    private IParseNode resultParseNode;
    private ParseStack[] parseStacks;
    private ParseStack[] tokenParseStacks;
    private boolean[] tokenRecognition;

    public ParseResult(boolean inError) {
        this.inError = inError;
    }

    public void setResultParseNode(IParseNode resultParseNode) {
        this.resultParseNode = resultParseNode;
    }

    public void setLastTerminalValueReaded(int lastTerminalValueReaded) {
        this.lastTerminalValueReaded = lastTerminalValueReaded;
    }

    public void setInTextPosition(int lineNumber, int columnNumber, String fileName) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public void setReduceError(boolean reduceError) {
        this.reduceError = reduceError;
    }

    public void setParseError(boolean parseError) {
        this.parseError = parseError;
    }

    public void setReduceErrorInfo(ParserException reduceException, int reduceErrorLineNumber, int reduceErrorColumnNumber, String reduceErrorFileName) {
        this.reduceErrorFileName = reduceErrorFileName;
        this.reduceException = reduceException;
        this.reduceErrorLineNumber = reduceErrorLineNumber;
        this.reduceErrorColumnNumber = reduceErrorColumnNumber;
    }

    public void setReduceErrorInfo(IParseNodeInErrorStatus parseNodeInErrorStatus, String reduceErrorFileName) {
        this.reduceErrorFileName = reduceErrorFileName;
        this.parseNodeInErrorStatus = parseNodeInErrorStatus;
    }

    public boolean isInError() {
        return this.inError;
    }

    public IParseNode getResultParseNode() {
        return this.resultParseNode;
    }

    public IParseNodeData getUniqData() {
        return this.resultParseNode.getUniqData();
    }

    public boolean isParseError() {
        return this.parseError;
    }

    public boolean isReduceError() {
        return this.reduceError;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Set<String> getExpectedNonTerminal() {
        return this.expectedNonTerminal;
    }

    public Set<TerminalCharRange> getExpectedTerminal() {
        return this.expectedTerminal;
    }

    public ParserException getReduceException() {
        return this.reduceException;
    }

    public IParseNodeInErrorStatus getParseNodeInErrorStatus() {
        return this.parseNodeInErrorStatus;
    }

    public String getReduceErrorFileName() {
        return this.reduceErrorFileName;
    }

    public int getReduceErrorLineNumber() {
        return this.reduceErrorLineNumber;
    }

    public int getReduceErrorColumnNumber() {
        return this.reduceErrorColumnNumber;
    }

    public void setParseStacks(ParseStack[] parseStacks, ParseStack[] tokenParseStacks, boolean[] tokenRecognition) {
        this.parseStacks = parseStacks;
        this.tokenParseStacks = tokenParseStacks;
        this.tokenRecognition = tokenRecognition;
    }

    public ParseStack[] getParseStacks() {
        return this.parseStacks;
    }

    public ParseStack[] getTokenParseStacks() {
        return this.tokenParseStacks;
    }

    public boolean[] getTokenRecognition() {
        return this.tokenRecognition;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inError) {
            stringBuilder.append("has parsing error\n");
        } else {
            stringBuilder.append("does not have parsing error\n");
        }
        if (this.parseError) {
            stringBuilder.append("parse failed: file ");
            stringBuilder.append(this.fileName);
            stringBuilder.append(", line ");
            stringBuilder.append(this.lineNumber);
            stringBuilder.append(" column ");
            stringBuilder.append(this.columnNumber);
            stringBuilder.append(", last character readed ");
            if (this.lastTerminalValueReaded == -1) {
                stringBuilder.append("EOF");
            } else if (this.lastTerminalValueReaded < 32 || this.lastTerminalValueReaded >= 127) {
                stringBuilder.append(String.format("0X%2X", this.lastTerminalValueReaded));
            } else {
                stringBuilder.append('\"');
                stringBuilder.append((char)this.lastTerminalValueReaded);
                stringBuilder.append('\"');
            }
            stringBuilder.append("\nexpected terminal:\n");
            for (TerminalCharRange terminalCharRange : this.expectedTerminal) {
                stringBuilder.append('\t');
                stringBuilder.append(terminalCharRange.toString());
                stringBuilder.append('\n');
            }
            stringBuilder.append("expected non terminal:\n");
            for (String nonTerminal : this.expectedNonTerminal) {
                stringBuilder.append('\t');
                stringBuilder.append(nonTerminal);
                stringBuilder.append('\n');
            }
        } else {
            stringBuilder.append("parse succeed\n");
        }
        if (this.reduceError) {
            stringBuilder.append("reduce error: file ");
            stringBuilder.append(this.reduceErrorFileName);
            stringBuilder.append('\n');
            if (this.reduceException != null) {
                stringBuilder.append("reduce exception: line ");
                stringBuilder.append(this.reduceErrorLineNumber);
                stringBuilder.append(", column ");
                stringBuilder.append(this.reduceErrorColumnNumber);
                DebugUtil debugUtil = DebugUtil.getInstance();
                stringBuilder.append(debugUtil.stackTrace(this.reduceException));
            }
            if (this.parseNodeInErrorStatus != null && this.parseNodeInErrorStatus.isInError()) {
                stringBuilder.append(this.parseNodeInErrorStatus.toString());
            }
        } else {
            stringBuilder.append("no reduce error\n");
        }
        if (this.parseStacks != null) {
            stringBuilder.append("syntax parse stacks\n");
            stringBuilder.append(parsingToStringUtil.parseStacksToString(this.parseStacks, this.tokenRecognition, false));
        }
        if (this.tokenParseStacks != null) {
            stringBuilder.append("lexical parse stacks\n");
            stringBuilder.append(parsingToStringUtil.parseStacksToString(this.tokenParseStacks, this.tokenRecognition, false));
        }
        return stringBuilder.toString();
    }
}

